/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.UIManager;
import java.util.Enumeration;
import java.util.Vector;

public class Container
extends Component {
    private Layout layout;
    private Vector components = new Vector();
    private boolean shouldLayout = true;
    private boolean scrollableX;
    private boolean scrollableY;
    private Vector cmpTransitions;

    public Container(Layout layout) {
        this.layout = layout;
        this.setFocusable(false);
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.setSmoothScrolling(laf.isDefaultSmoothScrolling());
    }

    public Container() {
        this(new FlowLayout());
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void invalidate() {
        this.setShouldCalcPreferredSize(true);
    }

    protected void setShouldCalcPreferredSize(boolean shouldCalcPreferredSize) {
        Form f;
        super.setShouldCalcPreferredSize(shouldCalcPreferredSize);
        this.shouldLayout = shouldCalcPreferredSize;
        Enumeration enums = this.components.elements();
        if (this.shouldLayout) {
            while (enums.hasMoreElements()) {
                Component cmp = (Component)enums.nextElement();
                if (!(cmp instanceof Container)) continue;
                ((Container)cmp).setShouldCalcPreferredSize(shouldCalcPreferredSize);
            }
        }
        if ((f = this.getComponentForm()) != null) {
            f.clearFocusVectors();
        }
    }

    public int getLayoutWidth() {
        if (this.isScrollableX()) {
            int scrollH = UIManager.getInstance().getLookAndFeel().getHorizontalScrollHeight();
            return Math.max(this.getWidth() + scrollH, this.getPreferredW() + scrollH);
        }
        Container parent = this.getScrollableParent();
        if (parent != null && parent.isScrollableX()) {
            return Math.max(this.getWidth(), this.getPreferredW());
        }
        int width = this.getWidth();
        if (width <= 0) {
            return this.getPreferredW();
        }
        return width;
    }

    public int getLayoutHeight() {
        if (this.isScrollableY()) {
            int scrollW = UIManager.getInstance().getLookAndFeel().getVerticalScrollWidth();
            return Math.max(this.getHeight() + scrollW, this.getPreferredH() + scrollW);
        }
        Container parent = this.getScrollableParent();
        if (parent != null && parent.isScrollableY()) {
            return Math.max(this.getHeight(), this.getPreferredH());
        }
        int height = this.getHeight();
        if (height <= 1) {
            return this.getPreferredH();
        }
        return height;
    }

    private Container getScrollableParent() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isScrollable()) continue;
            return parent;
        }
        return null;
    }

    public void addComponent(Component cmp) {
        if (this.layout instanceof BorderLayout) {
            throw new IllegalArgumentException("Cannot add component to BorderLayout Container without constraint parameter");
        }
        this.insertComponentAt(this.components.size(), cmp);
    }

    public void addComponent(Object constraints, Component cmp) {
        this.layout.addLayoutComponent(constraints, cmp, this);
        this.insertComponentAt(this.components.size(), cmp);
    }

    public void addComponent(int index, Object constraints, Component cmp) {
        this.layout.addLayoutComponent(constraints, cmp, this);
        this.insertComponentAt(index, cmp);
    }

    private void insertComponentAt(int index, Component cmp) {
        Form f;
        if (cmp.getParent() != null) {
            throw new IllegalArgumentException("Component is already contained in Container: " + cmp.getParent());
        }
        if (cmp instanceof Form) {
            throw new IllegalArgumentException("A form cannot be added to a container");
        }
        cmp.setParent(this);
        this.components.insertElementAt(cmp, index);
        this.setShouldCalcPreferredSize(true);
        if (this.isInitialized()) {
            cmp.initComponentImpl();
        }
        if ((f = this.getComponentForm()) != null) {
            f.clearFocusVectors();
        }
    }

    public void addComponent(int index, Component cmp) {
        this.insertComponentAt(index, cmp);
    }

    public void replaceAndWait(Component current, Component next, Transition t) {
        this.replaceComponents(current, next, t, true);
    }

    public void replace(Component current, Component next, Transition t) {
        this.replaceComponents(current, next, t, false);
    }

    private void replaceComponents(Component current, Component next, Transition t, boolean wait) {
        if (!this.contains(current)) {
            throw new IllegalArgumentException("Component " + current + " is not contained in this Container");
        }
        if (t == null || !this.isVisible() || this.getComponentForm() == null) {
            this.replace(current, next);
            return;
        }
        next.setX(current.getX());
        next.setY(current.getY());
        next.setWidth(current.getWidth());
        next.setHeight(current.getHeight());
        next.setParent(this);
        if (next instanceof Container) {
            ((Container)next).layoutContainer();
        }
        final Anim anim = new Anim(this, current, next, t);
        this.getComponentForm().registerAnimated(anim);
        if (wait) {
            Display.getInstance().invokeAndBlock(new Runnable(){

                public void run() {
                    while (!anim.isFinished()) {
                    }
                }
            });
        }
    }

    private boolean isParentOf(Component c) {
        if ((c = c.getParent()) == null || c instanceof Form) {
            return false;
        }
        return c == this || this.isParentOf(c);
    }

    private boolean requestFocusChild() {
        for (int iter = 0; iter < this.getComponentCount(); ++iter) {
            Component c = this.getComponentAt(iter);
            if (c.isFocusable()) {
                c.requestFocus();
                return true;
            }
            if (!(c instanceof Container) || !((Container)c).requestFocusChild()) continue;
            return true;
        }
        return false;
    }

    void replace(Component current, Component next) {
        int index = this.components.indexOf(current);
        boolean currentFocused = false;
        if (current.getComponentForm() != null) {
            Component currentF = current.getComponentForm().getFocused();
            boolean bl = currentFocused = currentF == current;
            if (!currentFocused && current instanceof Container && ((Container)current).isParentOf(currentF)) {
                currentFocused = true;
            }
        }
        if (this.layout instanceof BorderLayout) {
            Object constraint = this.layout.getComponentConstraint(current);
            this.removeComponent(current);
            this.layout.addLayoutComponent(constraint, next, this);
        } else {
            this.removeComponent(current);
        }
        next.setParent(null);
        if (index < 0) {
            index = 0;
        }
        this.insertComponentAt(index, next);
        if (currentFocused) {
            if (next.isFocusable()) {
                next.requestFocus();
            } else if (next instanceof Container) {
                ((Container)next).requestFocusChild();
            }
        }
    }

    void initComponentImpl() {
        if (!this.isInitialized()) {
            super.initComponentImpl();
        }
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            ((Component)e.nextElement()).initComponentImpl();
        }
    }

    public void removeComponent(Component cmp) {
        Form parentForm = cmp.getComponentForm();
        this.layout.removeLayoutComponent(cmp);
        cmp.deinitializeImpl();
        this.components.removeElement(cmp);
        cmp.setParent(null);
        cmp.setShouldCalcPreferredSize(true);
        if (parentForm != null) {
            if (parentForm.getFocused() == cmp || cmp instanceof Container && ((Container)cmp).contains(parentForm.getFocused())) {
                parentForm.setFocused(null);
            }
            parentForm.clearFocusVectors();
            if (cmp.isSmoothScrolling()) {
                parentForm.deregisterAnimated(cmp);
            }
        }
        this.setShouldCalcPreferredSize(true);
    }

    void deinitializeImpl() {
        int iter;
        super.deinitializeImpl();
        int size = this.components.size();
        for (iter = 0; iter < size; ++iter) {
            ((Component)this.components.elementAt(iter)).deinitializeImpl();
        }
        if (this.cmpTransitions != null) {
            size = this.cmpTransitions.size();
            for (iter = 0; iter < size; ++iter) {
                ((Anim)this.cmpTransitions.elementAt(iter)).destroy();
            }
            this.cmpTransitions.removeAllElements();
            this.cmpTransitions = null;
        }
    }

    public void removeAll() {
        Component focus;
        Form parentForm = this.getComponentForm();
        if (parentForm != null && (focus = parentForm.getFocused()) != null && this.contains(focus)) {
            parentForm.setFocused(null);
        }
        Object[] arr = new Object[this.components.size()];
        this.components.copyInto(arr);
        for (int i = 0; i < arr.length; ++i) {
            this.removeComponent((Component)arr[i]);
        }
    }

    public void revalidate() {
        this.setShouldCalcPreferredSize(true);
        Form root = this.getComponentForm();
        if (root != null) {
            root.layoutContainer();
            root.repaint();
        } else {
            this.layoutContainer();
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        this.layoutContainer();
        g.translate(this.getX(), this.getY());
        Enumeration enums = this.components.elements();
        while (enums.hasMoreElements()) {
            Component cmp = (Component)enums.nextElement();
            cmp.paintInternal(g, false);
        }
        g.translate(-this.getX(), -this.getY());
    }

    void paintIntersecting(Graphics g, Component cmp, Rectangle bounds, boolean above) {
        if (this.layout.isOverlapSupported() && this.components.contains(cmp)) {
            int endIndex;
            int startIndex;
            int indexOfComponent = this.components.indexOf(cmp);
            if (above) {
                startIndex = indexOfComponent + 1;
                endIndex = this.components.size();
            } else {
                startIndex = 0;
                endIndex = indexOfComponent;
            }
            for (int i = startIndex; i < endIndex; ++i) {
                Component cmp2 = (Component)this.components.elementAt(i);
                Rectangle rect = new Rectangle(cmp2.getBounds());
                rect.setX(cmp2.getAbsoluteX());
                rect.setY(cmp2.getAbsoluteY());
                if (!rect.intersects(bounds)) continue;
                cmp2.paintInternal(g, false);
            }
        }
    }

    public void layoutContainer() {
        if (this.shouldLayout) {
            this.shouldLayout = false;
            this.doLayout();
        }
    }

    void doLayout() {
        this.layout.layoutContainer(this);
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            if (!(c instanceof Container)) continue;
            ((Container)c).doLayout();
        }
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public Component getComponentAt(int index) {
        return (Component)this.components.elementAt(index);
    }

    public int getComponentIndex(Component cmp) {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            if (!c.equals(cmp)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Component cmp) {
        boolean found = false;
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            if (c.equals(cmp)) {
                return true;
            }
            if (!(c instanceof Container) || !(found = ((Container)c).contains(cmp))) continue;
            return true;
        }
        return false;
    }

    protected void scrollComponentToVisible(Component c) {
        if (this.isScrollable() && c != null) {
            Form f;
            if (c.getParent() != null && (f = this.getComponentForm()) != null && f.getFocusPosition(c) == 0) {
                this.scrollRectToVisible(new Rectangle(0, 0, c.getX() + c.getWidth(), c.getY() + c.getHeight()), c);
                return;
            }
            this.scrollRectToVisible(c.getBounds(), c);
        }
    }

    public Component getComponentAt(int x, int y) {
        int count = this.getComponentCount();
        for (int i = count - 1; i >= 0; --i) {
            Component cmp = this.getComponentAt(i);
            if (!cmp.contains(x, y)) continue;
            if (cmp instanceof Container) {
                return ((Container)cmp).getComponentAt(x, y);
            }
            return cmp;
        }
        if (this.contains(x, y)) {
            return this;
        }
        return null;
    }

    public void pointerHover(int[] x, int[] y) {
        Component c = this.getComponentAt(x[0], y[0]);
        if (c != null && c.isFocusable()) {
            c.requestFocus();
        }
    }

    public void pointerPressed(int x, int y) {
        if (!this.isDragActivated()) {
            Component cmp = this.getComponentAt(x, y);
            if (cmp == this) {
                super.pointerPressed(x, y);
            } else if (cmp != null) {
                cmp.pointerPressed(x, y);
            }
        }
    }

    protected Dimension calcPreferredSize() {
        Dimension d = this.layout.getPreferredSize(this);
        return d;
    }

    protected String paramString() {
        String className = this.layout.getClass().getName();
        String layoutStr = className.substring(className.lastIndexOf(46) + 1);
        return super.paramString() + ", layout = " + layoutStr + ", scrollableX = " + this.scrollableX + ", scrollableY = " + this.scrollableY + ", components = " + this.getComponentsNames();
    }

    private String getComponentsNames() {
        String ret = "[";
        Enumeration enums = this.components.elements();
        while (enums.hasMoreElements()) {
            String className = enums.nextElement().getClass().getName();
            ret = ret + className.substring(className.lastIndexOf(46) + 1) + ", ";
        }
        if (ret.length() > 1) {
            ret = ret.substring(0, ret.length() - 2);
        }
        ret = ret + "]";
        return ret;
    }

    public void refreshTheme() {
        super.refreshTheme();
        Enumeration enums = this.components.elements();
        while (enums.hasMoreElements()) {
            Component cmp = (Component)enums.nextElement();
            cmp.refreshTheme();
        }
    }

    public boolean isScrollableX() {
        return this.scrollableX && this.getPreferredW() > this.getWidth();
    }

    public boolean isScrollableY() {
        return this.scrollableY && this.getPreferredH() > this.getHeight();
    }

    public void setScrollableX(boolean scrollableX) {
        this.scrollableX = scrollableX;
    }

    public void setScrollableY(boolean scrollableY) {
        this.scrollableY = scrollableY;
    }

    public void setScrollable(boolean scrollable) {
        this.setScrollableX(scrollable);
        this.setScrollableY(scrollable);
    }

    public void setCellRenderer(boolean cellRenderer) {
        if (this.isCellRenderer() != cellRenderer) {
            super.setCellRenderer(cellRenderer);
            int size = this.getComponentCount();
            for (int iter = 0; iter < size; ++iter) {
                this.getComponentAt(iter).setCellRenderer(cellRenderer);
            }
        }
    }

    protected String getUIID() {
        return "Container";
    }

    class Anim
    implements Animation {
        private Transition t;
        private Component current;
        private Component next;
        private boolean started = false;
        private Container thisContainer;
        private boolean finished = false;
        private Form parent;

        public Anim(Container thisContainer, Component current, Component next, Transition t) {
            this.t = t;
            this.next = next;
            this.current = current;
            this.thisContainer = thisContainer;
            this.parent = thisContainer.getComponentForm();
        }

        public boolean animate() {
            boolean notFinished;
            if (!this.started) {
                this.t.init(this.current, this.next);
                this.t.initTransition();
                this.started = true;
                if (Container.this.cmpTransitions == null) {
                    Container.this.cmpTransitions = new Vector();
                }
                Container.this.cmpTransitions.addElement(this);
            }
            if (!(notFinished = this.t.animate())) {
                this.destroy();
                Container.this.cmpTransitions.removeElement(this);
            }
            return notFinished;
        }

        public void destroy() {
            this.parent.deregisterAnimated(this);
            this.next.setParent(null);
            this.thisContainer.replace(this.current, this.next);
            this.t.cleanup();
            this.parent.revalidate();
            this.finished = true;
        }

        public void paint(Graphics g) {
            this.t.paint(g);
        }

        public boolean isFinished() {
            return this.finished;
        }
    }
}

